function poly = POLYbestresult_D(x,y,id)
kfold = max(id);
d_iter = 1:5;
r_iter = [0,0.1,0.2,0.5,1,2];
mse_test = 10^10;
mse_train = 10^10;
n1 = length(d_iter);
n2 = length(r_iter);
for i = 1:length(d_iter)
    for j = 1:length(r_iter)
    d = d_iter(i);
    r = r_iter(j);
    kernel_train = cell(kfold,1);
     kernel_test = cell(kfold,1);
     y_train = cell(kfold,1);
     y_test = cell(kfold,1);
     for q = 1:kfold
         id_train = find(id ~= q);
         id_test = find(id == q);
         kernel_train{q} = gramPOLY(x(id_train,:),x(id_train,:),d,r);
         kernel_test{q} = gramPOLY(x(id_test,:),x(id_train,:),d,r);
         y_train{q} = y(id_train);
         y_test{q} = y(id_test);
     end
     [mse_current_test,mse_current_train,lambda_current] = give_me_best_mse(kernel_train,kernel_test,y_train,y_test);
      if mse_current_test < mse_test
         mse_test = mse_current_test;
         mse_train = mse_current_train;
         lambda = lambda_current;
         best_d = d;
         best_r = r;
      end 
      %percent_complete =  100*( (i-1)*n2 + j )/(n1*n2);
      %fprintf('POLY: %.2f percent complete with best mse: %.5f \n',percent_complete,mse_test);
    end
end
poly = struct();
poly.mse_test_kfold = mse_test;
poly.mse_train_kfold = mse_train;
poly.d = best_d;
poly.r = best_r;
poly.lambda = lambda;
end